<?php

use yii\bootstrap5\ActiveForm;
use yii\bootstrap5\Html;
use yii\widgets\MaskedInput; ?>
<div class="reg">
    <div class="col-lg-5">
        <div class="zagolovok">
            <h2>Форма для брони</h2>
        </div>
        <?php
        $form = ActiveForm::begin([
            'id' => 'login-form',
            'options' => ['class' => 'form-horizontal'],
        ]) ?>
        <?= $form->field($model, 'hotelnumber_id')->dropDownList(
            $hotelnumbers,
            ['prompt' => 'Выберите вид номеров']
        ) ?>
        <?= $form->field($model, 'date_here')->widget(MaskedInput::class, [
            'mask' => '99.99.9999 99:99',
        ]) ?>
        <?= $form->field($model, 'date_out')->widget(MaskedInput::class, [
            'mask' => '99.99.9999 99:99',
        ]) ?>
        <div class="count_guest">
            <p>Количество гостей:</p>
            <?= $form->field($model, 'adults')->textInput() ?>
            <?= $form->field($model, 'kinders')->textInput() ?>
        </div>
        <?= $form->field($model, 'payment_method')->radioList([
            0 => 'Наличными',
            1 => 'Банковской картой'
        ]) ?>
        <div class="form-group">
            <div class="form-check">
                <input type="checkbox" id="additional-services" class="form-check-input"
                       onchange="document.getElementById('content-field').style.display = this.checked ? 'block' : 'none'">
                <label class="form-check-label" for="additional-services">Дополнительные услуги</label>
            </div>
        </div>
        <div id="content-field" style="display: none;">
            <?= $form->field($model, 'content')->textarea([
                'rows' => 4,
                'placeholder' => 'Опишите дополнительные услуги, которые вас интересуют...'
            ]) ?>
        </div>
        <?= Html::submitButton('Отправить', ['class' => 'btn btn-primary']) ?>
        <?php ActiveForm::end() ?>
    </div>
</div>