<?php

namespace app\models;

use yii\base\Model;

class SignupForm extends Model
{

    public $surname;
    public $name;
    public $patronymic;
    public $login;
    public $passport;
    public $adres;
    public $phone_number;
    public $email;
    public $password;


    public function rules()
    {
        return [
            [['surname', 'name', 'patronymic', 'login', 'passport', 'adres', 'phone_number', 'email', 'password'], 'required'],
            [['surname', 'name', 'patronymic'], 'match', 'pattern' => '/^[а-яА-ЯёЁ\s\-]+$/u', 'message' => 'Только символы русского алфавита!'],
            [['surname', 'name', 'patronymic'], 'string', 'max' => 50],
            ['login', 'unique', 'targetClass' => User::class, 'message' => 'Такой логин уже существует'],
            ['login', 'match', 'pattern' => '/^[a-zA-Z0-9]+$/', 'message' => 'Логин должен состоять из символов латинского алфавита и цифр'],
            ['login', 'string'],
            ['email', 'email'],
            ['email', 'unique', 'targetClass' => User::class, 'message' => 'Аккаунт с таким электронным адресом существует'],
            ['password', 'string', 'min' => 7, 'max' => 255],
            ['phone_number', 'match', 'pattern' => '/^\+7\(\d{3}\)-\d{3}-\d{2}-\d{2}$/', 'message' => 'Неверный формат номера телефона'],
            ['passport', 'match', 'pattern' => '/^\d{10}$/', 'message' => 'Введите 10 цифр из паспорта'],
            ['adres', 'string', 'max' => 255],
        ];
    }

    public function attributeLabels()
    {
        return [
            'surname' => 'Фамилия',
            'name' => 'Имя',
            'patronymic' => 'Отчество',
            'login' => 'Логин',
            'passport' => 'Паспорт',
            'adres' => 'Адрес',
            'phone_number' => 'Номер телефона',
            'email' => 'Email',
            'password' => 'Пароль',
        ];
    }

    public function signup()
    {
        if (!$this->validate()) {
            return null;
        }

        $user = new User();
        $user->surname = $this->surname;
        $user->name = $this->name;
        $user->patronymic = $this->patronymic;
        $user->login = $this->login;
        $user->passport = $this->passport;
        $user->adres = $this->adres;
        $user->phone_number = $this->phone_number;
        $user->email = $this->email;
        $user->setPassword($this->password);

        return $user->save() ? $user : null;
    }
}